unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  BaseMainHMACData, StdCtrls, ExtCtrls, stDERUtils, 
  stSecUtils, stReadStrm;

type
  TfrmMain = class(TfrmBaseMainDigestData)
  private
    function GetHashClass: tHashClass; 
  public
    function DigestString(const aInput: OctetString): OctetString; override;
    function DigestFile(const aFilename: string): OctetString; override;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

{ TfrmMain }

function TfrmMain.DigestFile(const aFilename: string): OctetString;
begin
  raise Exception.Create('Not supported: Use the DigestFile routine');
end;

function TfrmMain.DigestString(const aInput: OctetString): OctetString;
var
  lH: tHash;
  lKey: OctetString;
begin
  lH := GetHashClass.CreateUnkeyed(False);
  try
    lH.KeyedHashMethod := khmHMAC;
    lKey := HMACKey;
    lH.Key := tSecretKey.CreateStr(PAnsiChar(AsPtr(lKey)),LengthOS(lKey));
    lH.SetUp;
    lH.HashData(AsPtr(aInput)^,LengthOS(aInput));
    lH.Done(nil);
    Result := lH.Digest;
  finally
    lH.Free;
  end;
end;

function TfrmMain.GetHashClass: tHashClass;
begin
  Result := MustFindHashClass(HashAlgorithm);
end;

end.
